package com.biz.crm.cps.external.tax.raise.sdk.dto.capital;

import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 付款信息参数dto
 * @Author: wjx
 * @Date: 2022/3/23 15:18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaxRaisePaymentDto", description = "付款信息参数dto")
public class TaxRaisePaymentDto extends MerchantAccountDto {

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  private String customerType;

  /**
   * 付款金额
   */
  @ApiModelProperty("付款金额")
  private BigDecimal paymentAmount;

  /**
   * 账户编码
   */
  @ApiModelProperty("账户编码")
  private String accountCode;

  /**
   * 付款时间
   */
  @ApiModelProperty(name = "paymentTime", value = "付款时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date paymentTime;

  /**
   * 确认时间
   */
  @ApiModelProperty(name = "confirmTime", value = "确认时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date confirmTime;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  private String dataSource;

  /**
   * 兑付流水编码
   */
  @ApiModelProperty("兑付流水编码")
  private String cashCode;

  /**
   * 回调地址
   */
  @ApiModelProperty("回调地址")
  private String returnUrl;

}
