package com.biz.crm.cps.external.tax.raise.sdk.dto.capital;

import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 充值信息参数dto
 * @Author: wjx
 * @Date: 2022/3/23 15:18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaxRaiseRechargeDto", description = "充值信息参数dto")
public class TaxRaiseRechargeDto extends MerchantAccountDto {

  /**
   * 删除标识
   */
  @ApiModelProperty("删除标识")
  private String delFlag;

  /**
   * 启用禁用状态
   */
  @ApiModelProperty("启用禁用状态")
  private String enableStatus;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String TenantCode;


  //充值提示信息

  /**
   * 充值提示编码 (查询充值渠道信息)
   */
  @ApiModelProperty("充值提示编码")
  private String rechargeTipCode;


  //充值信息

  /**
   * 充值编码
   */
  @ApiModelProperty("充值编码")
  private String rechargeCode;

  /**
   * 充值账户编码
   */
  @ApiModelProperty("充值账户编码")
  private String accountCode;

  /**
   * 账户名称
   */
  @ApiModelProperty("充值账户名称")
  private String accountName;

  /**
   * 充值金额
   */
  @ApiModelProperty("充值金额")
  private BigDecimal rechargeAmount;

  /**
   * 审核状态
   */
  @ApiModelProperty("审核状态")
  private String auditStatus;

  /**
   * 充值状态
   */
  @ApiModelProperty("充值状态")
  private String rechargeStatus;

  /**
   * 充值来源
   */
  @ApiModelProperty("充值来源")
  private String rechargeSource;

  /**
   * 充值时间
   */
  @ApiModelProperty(name = "confirmTime", value = "充值时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date rechargeTime;

  /**
   * 确认时间
   */
  @ApiModelProperty(name = "confirmTime", value = "确认时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date confirmTime;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  private String dataSource;

  /**
   * 回调地址
   */
  @ApiModelProperty("回调地址")
  private String returnUrl;

}
