package com.biz.crm.cps.external.tax.raise.sdk.dto.capital;

import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 充值信息查询dto
 * @Author: wjx
 * @Date: 2022/3/28 17:36
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaxRaiseRechargeDto", description = "充值信息查询dto")
public class TaxRaiseRechargeQueryDto  extends MerchantAccountDto {

  /**
   * 充值编码
   */
  @ApiModelProperty("充值编码")
  private String rechargeCode;


  /**
   * 充值状态
   */
  @ApiModelProperty("充值状态")
  private String rechargeStatus;

  /**
   * 审核状态
   */
  @ApiModelProperty("审核状态")
  private String auditStatus;

  /**
   * 充值来源
   */
  @ApiModelProperty("充值来源")
  private String rechargeSource;

  /**
   * 确认时间
   */
  @ApiModelProperty(name = "confirmTime", value = "确认时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date confirmTime;

  /**
   * 创建开始时间
   */
  @ApiModelProperty(name = "startCreateTime", value = "创建开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startCreateTime;

  /**
   * 创建结束时间
   */
  @ApiModelProperty(name = "endCreateTime", value = "创建结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endCreateTime;
}
