package com.biz.crm.cps.external.tax.raise.sdk.dto.recharge;

import com.biz.crm.cps.external.tax.raise.sdk.dto.base.BaseTaxRaiseDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 税筹充值实名认证账号信息分页列表查询条件Dto
 *
 * @author ning.zhang
 * @date 2022/3/14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaxRaiseRechargeAccountPageDto", description = "税筹充值实名认证账号信息分页列表查询条件Dto")
public class TaxRaiseRechargeAccountPageDto implements BaseTaxRaiseDto {

  /**
   * 企业名称
   */
  @ApiModelProperty("企业名称")
  private String companyName;

  /**
   * 统一社会信用代码(多合一证件)
   */
  @ApiModelProperty("统一社会信用代码(多合一证件)")
  private String organization;

  /**
   * 创建开始时间
   */
  @ApiModelProperty("创建开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createStartTime;

  /**
   * 创建结束时间
   */
  @ApiModelProperty("创建结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createEndTime;

}
