package com.biz.crm.cps.external.tax.raise.sdk.dto.recharge;

import com.biz.crm.cps.external.tax.raise.sdk.dto.base.BaseTaxRaiseDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 税筹充值合同分页列表查询条件Dto
 *
 * @author ning.zhang
 * @date 2022/3/14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaxRaiseRechargeContractPageDto", description = "税筹充值合同分页列表查询条件Dto")
public class TaxRaiseRechargeContractPageDto implements BaseTaxRaiseDto {

  /**
   * 合同编码
   */
  @ApiModelProperty("合同编码")
  private String contractId;

  /**
   * 合同模版名称
   */
  @ApiModelProperty(value = "合同模版名称")
  private String templateName;

  /**
   * 企业名称
   */
  @ApiModelProperty(value = "企业名称")
  private String companyName;

  /**
   * 创建开始时间
   */
  @ApiModelProperty("创建开始时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createStartTime;

  /**
   * 创建结束时间
   */
  @ApiModelProperty("创建结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createEndTime;

}
