package com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal;

import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 提现账号参数dto
 *
 * @author ning.zhang
 * @date 2022/3/18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaxRaiseWithdrawalAccountDto", description = "提现账号参数dto")
public class TaxRaiseWithdrawalAccountDto extends MerchantAccountDto {

  /**
   * 账户类型 1:个⼈ 2:企业
   */
  @ApiModelProperty("账户类型")
  private String accountType;

  /**
   * 返回路径
   */
  @ApiModelProperty("返回路径")
  private String returnUrl;
}
