package com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal;

import com.biz.crm.cps.external.tax.raise.sdk.dto.base.BaseTaxRaiseDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 税筹提现实名认证账号信息分页列表查询条件Dto
 *
 * @author ning.zhang
 * @date 2022/3/14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaxRaiseWithdrawalAccountPageDto", description = "税筹提现实名认证账号信息分页列表查询条件Dto")
public class TaxRaiseWithdrawalAccountPageDto implements BaseTaxRaiseDto {

  /**
   * 身份证姓名
   */
  @ApiModelProperty("身份证姓名")
  private String personName;

  /**
   * 身份证号
   */
  @ApiModelProperty("身份证号")
  private String idCard;

  /**
   * 创建开始时间
   */
  @ApiModelProperty("创建开始时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createStartTime;

  /**
   * 创建结束时间
   */
  @ApiModelProperty("创建结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createEndTime;

}
