package com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal;

import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 税筹提现合同签署查询Dto
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaxRaiseWithdrawalContractSignDto", description = "税筹提现合同签署查询Dto")
public class TaxRaiseWithdrawalContractSignDto extends MerchantAccountDto {

  /**
   * 合同模版编码
   */
  @ApiModelProperty("合同模版编码")
  private String templateCode;

  /**
   * 返回路径
   */
  @ApiModelProperty("返回路径")
  private String returnUrl;
}
