package com.biz.crm.cps.external.tax.raise.sdk.enums.recharge;

import java.util.Arrays;
import java.util.Objects;

/**
 * 税筹充值证书申请状态
 *
 * @author ning.zhang
 * @date 2022/3/8
 */
public enum TaxRaiseRechargeCertStatusEnum {

  /**
   * 未申请
   */
  NO("taxRaiseRechargeCertStatus","0", "未申请","1"),

  /**
   * 申请成功
   */
  SUCCESS("taxRaiseRechargeCertStatus","1", "申请成功","2"),

  /**
   * 身份证不匹配，重新认证
   */
  AGAIN("taxRaiseRechargeCertStatus","2", "身份证不匹配，重新认证","3"),

  /**
   * 申请失败
   */
  FAIL("taxRaiseRechargeCertStatus","3", "申请失败","3"),;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  TaxRaiseRechargeCertStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 TaxRaiseRechargeAccountTypeEnum
   *
   * @param key
   * @return
   */
  public static TaxRaiseRechargeCertStatusEnum getByKey(String key) {
    return Arrays.stream(TaxRaiseRechargeCertStatusEnum.values()).filter(item ->Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
