package com.biz.crm.cps.external.tax.raise.sdk.enums.recharge;

import java.util.Arrays;
import java.util.Objects;

/**
 * 税筹充值个人账户认证状态类型
 *
 * @author ning.zhang
 * @date 2022/3/8
 */
public enum TaxRaiseRechargePersonVerifyStatusEnum {
  /**
   * 未激活
   */
  INACTIVATED("0", "0", "未激活", "1"),
  /**
   * 未认证
   */
  NOT_CERTIFIED("1", "1", "未认证", "2"),
  /**
   * 审核通过
   */
  PASSED("2", "2", "审核通过", "3"),
  /**
   * 已提交待审核
   */
  PENDING_REVIEW("3", "3", "已提交待审核", "4"),
  /**
   * 审核不通过
   */
  NOT_PASSED("4", "4", "审核不通过", "5"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  TaxRaiseRechargePersonVerifyStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 TaxRaiseRechargeAccountTypeEnum
   *
   * @param key
   * @return
   */
  public static TaxRaiseRechargePersonVerifyStatusEnum getByKey(String key) {
    return Arrays.stream(TaxRaiseRechargePersonVerifyStatusEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
