package com.biz.crm.cps.external.tax.raise.sdk.enums.withdrawal;

import java.util.Arrays;
import java.util.Objects;

/**
 * 税筹提现账户类型
 *
 * @author ning.zhang
 * @date 2022/3/8
 */
public enum TaxRaiseWithdrawalAccountTypeEnum {
  /**
   * 个⼈
   */
  PERSON("taxRaiseWithdrawalAccountType","1", "个⼈","1"),
  /**
   * 企业
   */
  COMPANY("taxRaiseWithdrawalAccountType","2", "企业","2"),;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  TaxRaiseWithdrawalAccountTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 TaxRaiseWithdrawalAccountTypeEnum
   *
   * @param key
   * @return
   */
  public static TaxRaiseWithdrawalAccountTypeEnum getByKey(String key) {
    return Arrays.stream(TaxRaiseWithdrawalAccountTypeEnum.values()).filter(item ->Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
