package com.biz.crm.cps.external.tax.raise.sdk.enums.withdrawal;

import java.util.Arrays;
import java.util.Objects;

/**
 * 税筹提现企业账户认证状态类型
 *
 * @author ning.zhang
 * @date 2022/3/8
 */
public enum TaxRaiseWithdrawalCompanyVerifyStatusEnum {
  /**
   * 未认证
   */
  NOT_CERTIFIED("0", "0", "未认证", "1"),
  /**
   * 管理员资料已提交
   */
  MATERIAL_SUBMIT("1", "1", "管理员资料已提交", "2"),
  /**
   * 企业基本资料(没有申请表)已提交
   */
  COMPANY_MATERIAL_SUBMIT("2", "2", "企业基本资料(没有申请表)已提交", "3"),
  /**
   * 已提交待审核
   */
  PENDING_REVIEW("3", "3", "已提交待审核", "4"),
  /**
   * 审核通过
   */
  PASSED("4", "4", "审核通过", "5"),
  /**
   * 审核不通过
   */
  NOT_PASSED("5", "5", "审核不通过", "6"),
  /**
   * ⼈⼯初审通过
   */
  PERSON_PASSED("6", "6", "⼈⼯初审通过", "7"),;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  TaxRaiseWithdrawalCompanyVerifyStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 TaxRaiseWithdrawalAccountTypeEnum
   *
   * @param key
   * @return
   */
  public static TaxRaiseWithdrawalCompanyVerifyStatusEnum getByKey(String key) {
    return Arrays.stream(TaxRaiseWithdrawalCompanyVerifyStatusEnum.values()).filter(item ->Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
