package com.biz.crm.cps.external.tax.raise.sdk.enums.withdrawal;

import java.util.Arrays;
import java.util.Objects;

/**
 * 提现合同签署状态
 *
 * @author ning.zhang
 * @date 2022/3/9
 */
public enum TaxRaiseWithdrawalContractSignStatus {
  /**
   * 未签署
   */
  SIGN("withdrawalContractSignStatus","3000", "签章成功","1"),
  /**
   * 已签署
   */
  SIGNED("withdrawalContractSignStatus","3001", "签章失败","2"),;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  TaxRaiseWithdrawalContractSignStatus(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 TaxRaiseWithdrawalContractSignStatus
   *
   * @param key key值
   * @return TaxRaiseWithdrawalContractSignStatus
   */
  public static TaxRaiseWithdrawalContractSignStatus getByKey(String key) {
    return Arrays.stream(TaxRaiseWithdrawalContractSignStatus.values()).filter(item ->Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
