package com.biz.crm.cps.external.tax.raise.sdk.service.capital;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseCapitalAccountTransactionQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseCapitalAccountTransactionVo;
import org.springframework.data.domain.Pageable;

/**
 * 税筹平台资金账户收支明细服务接口类
 * @Author: wjx
 * @Date: 2022/3/28 10:38
 */
public interface TaxRaiseCapitalAccountTransactionVoService {

  /**
   * 分页查询账户收支明细
   * @param pageable
   * @param dto
   * @return
   */
  Page<TaxRaiseCapitalAccountTransactionVo> findByConditions(Pageable pageable, TaxRaiseCapitalAccountTransactionQueryDto dto);

  /**
   * 分页查询当前用户账户收支明细
   * @param pageable
   * @param dto
   * @return
   */
  Page<TaxRaiseCapitalAccountTransactionVo> findCurrentUserByConditions(Pageable pageable, TaxRaiseCapitalAccountTransactionQueryDto dto);
}
