package com.biz.crm.cps.external.tax.raise.sdk.service.capital;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxDeductionAmountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseCapitalAccountQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseCapitalAccountVo;
import org.springframework.data.domain.Pageable;

/**
 * 税筹平台资金账户信息服务接口类
 * @Author: wjx
 * @Date: 2022/3/23 17:07
 */
public interface TaxRaiseCapitalAccountVoService {

  /**
   * 资金账户信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<FadadaRechargeAccountReportVo> 资金账户信息分页列表
   */
  Page<TaxRaiseCapitalAccountVo> findByConditions(Pageable pageable, TaxRaiseCapitalAccountQueryDto dto);

  /**
   * 通过当前登录商户账号信息获取账户资金信息
   * @return
   */
  TaxRaiseCapitalAccountVo findByCurrentUser();

  /**
   * 扣减账户资金
   * @param dto
   */
  void deductAmountByDeductionAmountDto(TaxDeductionAmountDto dto);

  /**
   * 通过商户账号信息获取账户资金信息
   * @return
   */
  TaxRaiseCapitalAccountVo findByMerchantUserAccount(String merchantUserAccount);
}
