package com.biz.crm.cps.external.tax.raise.sdk.service.capital;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseRechargeVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 税筹平台充值vo信息服务接口类
 * @Author: wjx
 * @Date: 2022/3/23 15:12
 */
public interface TaxRaiseRechargeVoService {

  /**
   * 创建充值信息
   *
   * @param dto 请求参数dto
   * @return 充值信息
   */
  TaxRaiseRechargeVo create(TaxRaiseRechargeDto dto);

  /**
   *根据充值编号手动推送充值信息
   * @param rechargeCode
   * @return
   */
  TaxRaiseRechargeVo pushByRechargeCode(String rechargeCode);

  /**
   * 分页查询充值信息
   * @param pageable
   * @param dto
   * @return
   */
  Page<TaxRaiseRechargeVo> findByConditions(Pageable pageable, TaxRaiseRechargeQueryDto dto);

  /**
   * 推送税筹平台(批量)
   * @param taxRaiseRechargeDtos
   */
  void pushRechargeBatch(List<TaxRaiseRechargeDto> taxRaiseRechargeDtos);
}
