package com.biz.crm.cps.external.tax.raise.sdk.service.recharge;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseCustomerDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeAccountPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeAccountVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 税筹平台充值账户信息Vo服务接口类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
public interface TaxRaiseRechargeAccountVoService {

  /**
   * 通过商户账号信息获取充值账号信息
   *
   * @param dto 请求参数dto
   * @return 充值账号信息
   */
  TaxRaiseRechargeAccountVo findByMerchantAccountDto(MerchantAccountDto dto);

  /**
   * 通过当前登录信息获取充值账号信息
   *
   * @return 充值账号信息
   */
  TaxRaiseRechargeAccountVo findCurrentByMerchantAccountDto();

  /**
   * 通过商户账号信息批量获取充值账号信息
   *
   * @param dto 请求参数dto
   * @return 提现账号信息
   */
  List<TaxRaiseRechargeAccountVo> findByMerchantAccountBatchDto(MerchantAccountBatchDto dto);

  /**
   * 充值实名认证账号信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<FadadaRechargeAccountReportVo> 充值实名认证账号信息分页列表
   */
  Page<TaxRaiseRechargeAccountVo> findByConditions(Pageable pageable, TaxRaiseRechargeAccountPageDto dto);

  /**
   * 创建充值账号信息
   *
   * @param dto 请求参数dto
   * @return 充值账号信息
   */
  TaxRaiseRechargeAccountVo create(TaxRaiseRechargeAccountDto dto);

  /**
   * 品牌商创建充值账号信息
   *
   * @return 充值账号信息
   */
  TaxRaiseRechargeAccountVo createByBrandBusiness();

  /**
   * 身份证批量下载zip
   *
   * @param dto 参数dto
   * @return 下载结果
   */
  String downloadIdentification(TaxRaiseCustomerDto dto);

  /**
   * 营业执照批量下载zip
   *
   * @param dto 参数dto
   * @return 下载结果
   */
  String downloadBusinessLicense(TaxRaiseCustomerDto dto);
}
