package com.biz.crm.cps.external.tax.raise.sdk.service.recharge;


import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeContractSignDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractSignVo;

/**
 * 税筹充值合同签署vo服务接口类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
public interface TaxRaiseRechargeContractSignVoService {

  /**
   * 获取账号充值合同签署信息
   *
   * @param dto 参数dto
   * @return 账号充值合同签署信息
   */
  TaxRaiseRechargeContractSignVo findByTaxRaiseRechargeContractSignDto(TaxRaiseRechargeContractSignDto dto);

  /**
   * 充值合同签署
   *
   * @param dto 参数dto
   * @return 充值合同签署信息
   */
  TaxRaiseRechargeContractSignVo create(TaxRaiseRechargeContractSignDto dto);

  /**
   * 品牌商创建合同签署信息
   *
   * @return 合同签署信息
   */
  TaxRaiseRechargeContractSignVo createByBrandBusiness();
}
