package com.biz.crm.cps.external.tax.raise.sdk.service.recharge;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseContractDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeContractPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractVo;
import org.springframework.data.domain.Pageable;

/**
 * 税筹充值合同VO服务接口类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
public interface TaxRaiseRechargeContractVoService {

  /**
   * 充值合同信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<TaxRaiseRechargeContractVo> 充值合同信息分页列表
   */
  Page<TaxRaiseRechargeContractVo> findByConditions(Pageable pageable, TaxRaiseRechargeContractPageDto dto);

  /**
   * 合同批量下载zip
   *
   * @param dto 参数dto
   * @return 下载结果
   */
  String downloadContract(TaxRaiseContractDto dto);
}
