package com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseCustomerDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalAccountPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalAccountVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 税筹平台提现账户信息Vo服务接口类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
public interface TaxRaiseWithdrawalAccountVoService {

  /**
   * 通过商户账号信息获取提现账号信息
   *
   * @param dto 请求参数dto
   * @return 提现账号信息
   */
  TaxRaiseWithdrawalAccountVo findByMerchantAccountDto(MerchantAccountDto dto);

  /**
   * 通过商户账号信息批量获取提现账号信息
   *
   * @param dto 请求参数dto
   * @return 提现账号信息
   */
  List<TaxRaiseWithdrawalAccountVo> findByMerchantAccountBatchDto(MerchantAccountBatchDto dto);

  /**
   * 提现实名认证账号信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<FadadaWithdrawalAccountReportVo> 提现实名认证账号信息分页列表
   */
  Page<TaxRaiseWithdrawalAccountVo> findByConditions(Pageable pageable, TaxRaiseWithdrawalAccountPageDto dto);

  /**
   * 创建提现账号信息
   *
   * @param dto 请求参数dto
   * @return 提现账号信息
   */
  TaxRaiseWithdrawalAccountVo create(TaxRaiseWithdrawalAccountDto dto);

  /**
   * 身份证批量下载zip
   *
   * @param dto 参数dto
   * @return 下载结果
   */
  String downloadIdentification(TaxRaiseCustomerDto dto);

  /**
   * 营业执照批量下载zip
   *
   * @param dto 参数dto
   * @return 下载结果
   */
  String downloadBusinessLicense(TaxRaiseCustomerDto dto);
}
