package com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseContractDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalContractPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalContractVo;
import org.springframework.data.domain.Pageable;

/**
 * 税筹提现合同VO服务接口类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
public interface TaxRaiseWithdrawalContractVoService {

  /**
   * 提现合同信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<TaxRaiseWithdrawalContractVo> 提现合同信息分页列表
   */
  Page<TaxRaiseWithdrawalContractVo> findByConditions(Pageable pageable, TaxRaiseWithdrawalContractPageDto dto);

  /**
   * 合同批量下载zip
   *
   * @param dto 参数dto
   * @return 下载结果
   */
  String downloadContract(TaxRaiseContractDto dto);
}
