package com.biz.crm.cps.external.tax.raise.sdk.vo.capital;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 账户收支明细vo
 * @Author: wjx
 * @Date: 2022/3/28 10:21
 */
@Data
@ApiModel(value = "TaxRaiseCapitalAccountTransactionVo", description = "账户收支明细vo")
public class TaxRaiseCapitalAccountTransactionVo {
  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTime;

  /**
   * 商户平台id
   */
  @ApiModelProperty(value = "商户平台id")
  private String merchantId;

  /**
   * 商户平台名称
   */
  @ApiModelProperty(value = "商户平台名称")
  private String merchantName;

  /**
   * 交易编号
   */
  @ApiModelProperty("交易编号")
  private String transactionCode;

  /**
   * 关联业务编号 (充值或付款的单据编号)
   */
  @ApiModelProperty("关联业务编号")
  private String relevanceCode;

  /**
   * 认证编码
   */
  @ApiModelProperty("认证编码")
  private String customerId;


  /**
   * 账户编码
   */
  @ApiModelProperty("账户编码")
  private String accountCode;

  /**
   * 账户名称
   */
  @ApiModelProperty("充值账户名称")
  private String accountName;

  /**
   * 交易类型
   */
  @ApiModelProperty("交易类型")
  private String transactionType;

  /**
   * 业务类型
   */
  @ApiModelProperty("业务类型")
  private String businessType;

  /**
   * 交易金额
   */
  @ApiModelProperty("交易金额")
  private BigDecimal transactionAmount;

  /**
   * 当前余额
   */
  @ApiModelProperty("当前余额")
  private BigDecimal currentAmount;
}
