package com.biz.crm.cps.external.tax.raise.sdk.vo.capital;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 税筹账户资金信息Vo
 * @Author: wjx
 * @Date: 2022/3/23 17:03
 */
@Data
@ApiModel(value = "TaxRaiseCapitalAccountVo", description = "税筹账户资金信息Vo")
public class TaxRaiseCapitalAccountVo {

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTime;

  /**
   * 更新时间
   */
  @ApiModelProperty("更新时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date modifyTime;

  /**
   * 商户平台用户账户
   */
  @ApiModelProperty("商户平台用户账户")
  private String merchantUserAccount;

  /**
   * 认证编码
   */
  @ApiModelProperty("认证编码")
  private String customerId;

  /**
   * 账户编码
   */
  @ApiModelProperty("账户编码")
  private String accountCode;

  /**
   * 账户名称
   */
  @ApiModelProperty("充值账户名称")
  private String accountName;

  /**
   * 商户平台id
   */
  @ApiModelProperty(value = "商户平台id")
  private String merchantId;

  /**
   * 关联商户平台名称
   */
  @ApiModelProperty("关联商户平台名称")
  private String merchantName;

  /**
   * 累计资金
   */
  @ApiModelProperty("累计资金")
  private BigDecimal cumulativeAmount;

  /**
   * 剩余资金
   */
  @ApiModelProperty("剩余资金")
  private BigDecimal amount;

  /**
   * 开户银行
   *
   */
  @ApiModelProperty("开户银行")
  private String accountBank;

  /**
   * 累计发放资金
   */
  @ApiModelProperty("累计发放资金")
  private BigDecimal cumulativeGrantAmount;

  /**
   * 企业/个体工商户名称
   */
  @ApiModelProperty("企业/个体工商户名称")
  private String companyName;

  /**
   * 社会信用代码
   */
  @ApiModelProperty("社会信用代码")
  private String socialCreditCode;

  /**
   * 对公账户
   */
  @ApiModelProperty("对公账户")
  private String bankCardNo;

  /**
   * 法人/经营者姓名
   */
  @ApiModelProperty("法人/经营者姓名")
  private String rlegalPersonName;
}
