package com.biz.crm.cps.external.tax.raise.sdk.vo.capital;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 税筹付款信息Vo
 *
 * @author wjx
 * @date 2022/3/1
 */
@Data
@ApiModel(value = "TaxRaisePaymentVo", description = "税筹付款信息Vo")
public class TaxRaisePaymentVo {

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  private String customerType;

  /**
   * 付款金额
   */
  @ApiModelProperty("付款金额")
  private BigDecimal paymentAmount;

  /**
   * 账户编码
   */
  @ApiModelProperty("账户编码")
  private String accountCode;

  /**
   * 付款时间
   */
  @ApiModelProperty(name = "paymentTime", value = "付款时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date paymentTime;

  /**
   * 确认时间
   */
  @ApiModelProperty(name = "confirmTime", value = "确认时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date confirmTime;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  private String dataSource;


}
