package com.biz.crm.cps.external.tax.raise.sdk.vo.recharge;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 税筹充值实名认证账号信息Vo
 *
 * @author ning.zhang
 * @date 2022/3/1
 */
@Data
@ApiModel(value = "TaxRaiseRechargeAccountVo", description = "税筹充值实名认证账号信息Vo")
public class TaxRaiseRechargeAccountVo {

  /**
   * 认证编码
   */
  @ApiModelProperty("认证编码")
  private String customerId;

  /**
   * 账户类型(1:个⼈ 2:企业)
   * @see com.biz.crm.cps.external.tax.raise.sdk.enums.recharge.TaxRaiseRechargeAccountTypeEnum
   */
  @ApiModelProperty("账户类型(1:个⼈ 2:企业)")
  private String accountType;

  /**
   * 商户平台id
   */
  @ApiModelProperty(value = "商户平台id")
  private String merchantId;

  /**
   * 商户平台名称
   */
  @ApiModelProperty(value = "商户平台名称")
  private String merchantName;

  /**
   * 商户平台用户账户
   */
  @ApiModelProperty("商户平台用户账户")
  private String merchantUserAccount;

  /**
   * 组织类型(0:企业;1:政府/事业单位;2:其他组织;3:个体工商)
   */
  @ApiModelProperty("组织类型(0:企业;1:政府/事业单位;2:其他组织;3:个体工商)")
  private String organizationType;

  /**
   * 企业名称
   */
  @ApiModelProperty("企业名称")
  private String companyName;

  /**
   * 统一社会信用代码(多合一证件)
   */
  @ApiModelProperty("统一社会信用代码(多合一证件)")
  private String organization;

  /**
   * 法人姓名
   */
  @ApiModelProperty("法人姓名")
  private String legalName;

  /**
   * 银行名称
   */
  @ApiModelProperty("银行名称")
  private String bankName;

  /**
   * 银行卡号
   */
  @ApiModelProperty("银行卡号")
  private String bankCardNo;

  /**
   * 管理员类型(0:个人,1:法人,2:代理人)
   */
  @ApiModelProperty("管理员类型(0:个人,1:法人,2:代理人)")
  private String managerType;

  /**
   * 管理员名称
   */
  @ApiModelProperty("管理员名称")
  private String managerName;

  /**
   * 管理员手机号
   */
  @ApiModelProperty("管理员手机号")
  private String managerMobile;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTime;

  /**
   * 更新时间
   */
  @ApiModelProperty("更新时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date modifyTime;

  /**
   * 实名认证url
   */
  @ApiModelProperty("实名认证url")
  private String verifyUrl;

  /**
   * 申请证书状态(0：没有申请证书，1：成功申请证书, 2:身份证已被使用，请重新认证, 3：申请证书失败)
   */
  @ApiModelProperty("申请证书状态(0：没有申请证书，1：成功申请证书, 2:身份证已被使用，请重新认证, 3：申请证书失败)")
  private String certStatus;

  /**
   * 企业状态(0:未认证,1:管理员资料已提交,2:企业基本资料已提交,3:已提交待审核,4:审核通过,5:审核不通过,6人工初审通过)
   */
  @ApiModelProperty("企业状态(0:未认证,1:管理员资料已提交,2:企业基本资料已提交,3:已提交待审核,4:审核通过,5:审核不通过,6人工初审通过)")
  private String companyStatus;

  /**
   * 个人状态(0:未激活,1:未认证,2:审核通过,3:已提交待审核,4:审核不通过)
   */
  @ApiModelProperty("个人状态(0:未激活,1:未认证,2:审核通过,3:已提交待审核,4:审核不通过)")
  private String personStatus;

  /**
   * 企业审核不通过原因
   */
  @ApiModelProperty("企业审核不通过原因")
  private String companyAuditFailReason;

  /**
   * 个人审核不通过原因
   */
  @ApiModelProperty("个人审核不通过原因")
  private String personAuditFailReason;
}
