package com.biz.crm.cps.external.tax.raise.sdk.vo.recharge;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 税筹充值合同信息Vo
 *
 * @author ning.zhang
 * @date 2022/3/1
 */
@Data
@ApiModel(value = "TaxRaiseRechargeContractVo", description = "税筹充值合同信息Vo")
public class TaxRaiseRechargeContractVo {

  /**
   * 合同编码
   */
  @ApiModelProperty("合同编码")
  private String contractId;

  /**
   * 合同模版编码
   */
  @ApiModelProperty(value = "合同模版编码")
  private String templateCode;

  /**
   * 合同模版名称
   */
  @ApiModelProperty(value = "合同模版名称")
  private String templateName;

  /**
   * 商户平台id
   */
  @ApiModelProperty(value = "商户平台id")
  private String merchantId;

  /**
   * 商户平台名称
   */
  @ApiModelProperty(value = "商户平台名称")
  private String merchantName;

  /**
   * 认证编码
   */
  @ApiModelProperty("认证编码")
  private String customerId;

  /**
   * 组织类型(0:企业;1:政府/事业单位;2:其他组织;3:个体工商)
   */
  @ApiModelProperty("组织类型(0:企业;1:政府/事业单位;2:其他组织;3:个体工商)")
  private String organizationType;

  /**
   * 企业名称
   */
  @ApiModelProperty("企业名称")
  private String companyName;

  /**
   * 统一社会信用代码(多合一证件)
   */
  @ApiModelProperty("统一社会信用代码(多合一证件)")
  private String organization;

  /**
   * 法人姓名
   */
  @ApiModelProperty("法人姓名")
  private String legalName;

  /**
   * 银行名称
   */
  @ApiModelProperty("银行名称")
  private String bankName;

  /**
   * 银行卡号
   */
  @ApiModelProperty("银行卡号")
  private String bankCardNo;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTime;

  /**
   * 签署时间
   */
  @ApiModelProperty("签署时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date signTime;
}
