package com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 税筹提现合同签署信息Vo
 *
 * @author ning.zhang
 * @date 2022/3/1
 */
@Data
@ApiModel(value = "TaxRaiseWithdrawalContractSignVo", description = "税筹提现合同签署信息Vo")
public class TaxRaiseWithdrawalContractSignVo {
  /**
   * 交易号
   */
  @ApiModelProperty("交易号")
  private String transactionId;

  /**
   * 合同id
   */
  @ApiModelProperty("合同id")
  private String contractId;

  /**
   * 合同名称
   */
  @ApiModelProperty("合同名称")
  private String contractName;

  /**
   * 合同模版id
   */
  @ApiModelProperty("合同模版id")
  private String templateId;

  /**
   * 签署状态
   */
  @ApiModelProperty("签署状态")
  private String signStatus;

  /**
   * 签署描述
   */
  @ApiModelProperty("签署描述")
  private String signDesc;

  /**
   * 签署时间
   */
  @ApiModelProperty("签署时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date signTime;

  /**
   * 文档标题
   */
  @ApiModelProperty("文档标题")
  private String docTitle;

  /**
   * 合同下载地址
   */
  @ApiModelProperty("合同下载地址")
  private String downloadUrl;

  /**
   * 查看合同地址
   */
  @ApiModelProperty("查看合同地址")
  private String viewUrl;

  /**
   * 签署地址
   */
  @ApiModelProperty("签署地址")
  private String signUrl;

}
