package com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal;

import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 税筹提现合同模板Vo
 *
 * @author ning.zhang
 * @date 2022/3/1
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "TaxRaiseWithdrawalContractTemplateVo", description = "税筹提现合同模板Vo")
public class TaxRaiseWithdrawalContractTemplateVo extends UuidFlagOpVo {

  private static final long serialVersionUID = -5948916832939139102L;

  /**
   * 合同模版编码
   */
  @ApiModelProperty(value = "合同模版编码")
  private String templateCode;

  /**
   * 合同模版名称
   */
  @ApiModelProperty(value = "合同模版名称")
  private String templateName;

  /**
   * 合同模版url
   */
  @ApiModelProperty(value = "合同模版url")
  private String docUrl;

  /**
   * 合同模版描述
   */
  @ApiModelProperty(value = "合同模版描述")
  private String templateDescribe;

  /**
   * 范围类型(all:全部可见,assignMerchant:指定商户可见)
   */
  @ApiModelProperty("范围类型(all:全部可见,assignMerchant:指定商户可见)")
  private String scopeType;

  /**
   * 推送状态(notPush:未推送,havePush:已推送)
   */
  @ApiModelProperty("推送状态(notPush:未推送,havePush:已推送)")
  private String pushStatus;


}
