package com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 税筹提现合同信息Vo
 *
 * @author ning.zhang
 * @date 2022/3/1
 */
@Data
@ApiModel(value = "TaxRaiseWithdrawalContractVo", description = "税筹提现合同信息Vo")
public class TaxRaiseWithdrawalContractVo {

  /**
   * 合同编码
   */
  @ApiModelProperty("合同编码")
  private String contractId;

  /**
   * 合同模版编码
   */
  @ApiModelProperty(value = "合同模版编码")
  private String templateCode;

  /**
   * 合同模版名称
   */
  @ApiModelProperty(value = "合同模版名称")
  private String templateName;

  /**
   * 商户平台id
   */
  @ApiModelProperty(value = "商户平台id")
  private String merchantId;

  /**
   * 商户平台名称
   */
  @ApiModelProperty(value = "商户平台名称")
  private String merchantName;

  /**
   * 认证编码
   */
  @ApiModelProperty("认证编码")
  private String customerId;

  /**
   * 身份证姓名
   */
  @ApiModelProperty("身份证姓名")
  private String personName;

  /**
   * 身份证账号
   */
  @ApiModelProperty("身份证账号")
  private String idCard;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  private String mobile;

  /**
   * 银行账户
   */
  @ApiModelProperty("银行账户")
  private String bankCardNo;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTime;

  /**
   * 签署时间
   */
  @ApiModelProperty("签署时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date signTime;
}
