/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.weixin.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.external.weixin.local.config.WXAccountProperties;
import com.biz.crm.cps.external.weixin.local.config.WXPlatformAccountProperties;
import com.biz.crm.cps.external.weixin.sdk.common.enums.WXPlatformTypeEnum;
import com.biz.crm.cps.external.weixin.sdk.service.WXCacheVoService;
import com.biz.crm.cps.external.weixin.sdk.service.WXOpenVoService;
import com.biz.crm.cps.external.weixin.sdk.vo.WXJsConfigVo;
import com.biz.crm.cps.external.weixin.sdk.vo.WxAccessTokenRespVo;
import com.biz.crm.cps.external.weixin.sdk.vo.WxCacheVo;
import com.biz.crm.cps.external.weixin.sdk.vo.WxJsApiTicketRespVo;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class WXOpenVoServiceImpl
implements WXOpenVoService {
    private static final Logger log = LoggerFactory.getLogger(WXOpenVoServiceImpl.class);
    @Autowired
    private WXAccountProperties wxAccountProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WXCacheVoService wxCache;

    public String findAccessToken(String appType) {
        if (Objects.isNull(this.wxAccountProperties) || CollectionUtils.isEmpty(this.wxAccountProperties.getAccounts())) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)appType)) {
            appType = WXPlatformTypeEnum.OFFICIAL_ACCOUNT.getCode();
        }
        String finalAppType = appType;
        WXPlatformAccountProperties wxProperties = this.wxAccountProperties.getAccounts().stream().filter(item -> Objects.equals(item.getAppType(), finalAppType)).findFirst().orElse(null);
        if (Objects.isNull(wxProperties)) {
            return null;
        }
        String cacheKey = String.format("OPEN_CACHE_ACCESS_TOKEN:%s", wxProperties.getAppId());
        String accessToken = this.wxCache.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            log.debug("accessToken:{}", (Object)accessToken);
            return accessToken;
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("appid", wxProperties.getAppId());
        uriVariables.put("secret", wxProperties.getAppSecret());
        WxAccessTokenRespVo accessTokenRespVo = (WxAccessTokenRespVo)this.restTemplate.getForObject("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={appid}&secret={secret}", WxAccessTokenRespVo.class, uriVariables);
        if (Objects.isNull(accessTokenRespVo) && !Objects.equals(accessTokenRespVo.getErrcode(), "0")) {
            log.warn("\u83b7\u53d6\u5fae\u4fe1\u5168\u5c40ACCESS_TOKEN\u5931\u8d25\uff01{}", (Object)accessTokenRespVo.getErrmsg());
            return null;
        }
        accessToken = accessTokenRespVo.getAccessToken();
        WxCacheVo cacheVo = new WxCacheVo();
        cacheVo.setCreateTimestamp(new Date().getTime());
        cacheVo.setValue(accessToken);
        cacheVo.setExpiresIn(accessTokenRespVo.getExpiresIn());
        this.wxCache.set(cacheKey, JSONObject.toJSONString((Object)cacheVo));
        log.debug("accessToken:{}", (Object)accessToken);
        return accessToken;
    }

    public String findJsApiTicket(String appType) {
        if (Objects.isNull(this.wxAccountProperties)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)appType)) {
            appType = WXPlatformTypeEnum.OFFICIAL_ACCOUNT.getCode();
        }
        String finalAppType = appType;
        WXPlatformAccountProperties wxProperties = this.wxAccountProperties.getAccounts().stream().filter(item -> Objects.equals(item.getAppType(), finalAppType)).findFirst().orElse(null);
        if (Objects.isNull(wxProperties)) {
            return null;
        }
        String cacheKey = String.format("OPEN_CACHE_JSAPI_TICKET:%s", wxProperties.getAppId());
        String jsApiTicket = this.wxCache.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)jsApiTicket)) {
            log.debug("jsApiTicket:{}", (Object)jsApiTicket);
            return jsApiTicket;
        }
        String accessToken = this.findAccessToken(appType);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return null;
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("access_token", accessToken);
        uriVariables.put("type", "jsapi");
        WxJsApiTicketRespVo jsApiTicketRespVo = (WxJsApiTicketRespVo)this.restTemplate.getForObject("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token={access_token}&type={type}", WxJsApiTicketRespVo.class, uriVariables);
        if (Objects.isNull(jsApiTicketRespVo) && !Objects.equals(jsApiTicketRespVo.getErrcode(), "0")) {
            log.warn("\u83b7\u53d6\u5fae\u4fe1\u5168\u5c40JSAPI_TICKET\u5931\u8d25\uff01{}", (Object)jsApiTicketRespVo.getErrmsg());
            return null;
        }
        jsApiTicket = jsApiTicketRespVo.getTicket();
        WxCacheVo cacheVo = new WxCacheVo();
        cacheVo.setCreateTimestamp(new Date().getTime());
        cacheVo.setValue(jsApiTicket);
        cacheVo.setExpiresIn(jsApiTicketRespVo.getExpiresIn());
        this.wxCache.set(cacheKey, JSONObject.toJSONString((Object)cacheVo));
        log.debug("jsApiTicket:{}", (Object)jsApiTicket);
        return jsApiTicket;
    }

    public WXJsConfigVo findWXJsConfig(String url, String appType) {
        if (Objects.isNull(this.wxAccountProperties)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)appType)) {
            appType = WXPlatformTypeEnum.OFFICIAL_ACCOUNT.getCode();
        }
        String finalAppType = appType;
        WXPlatformAccountProperties wxProperties = this.wxAccountProperties.getAccounts().stream().filter(item -> Objects.equals(item.getAppType(), finalAppType)).findFirst().orElse(null);
        if (Objects.isNull(wxProperties)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            url = wxProperties.getDefaultPageUrl();
        }
        Validate.notBlank((CharSequence)url, (String)"\u83b7\u53d6jssdk\u7684url\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String jsapiTicket = this.findJsApiTicket(appType);
        if (StringUtils.isBlank((CharSequence)jsapiTicket)) {
            return null;
        }
        String nonceStr = UUID.randomUUID().toString();
        long timestamp = System.currentTimeMillis() / 1000L;
        String signOriginal = String.format("jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s", jsapiTicket, nonceStr, timestamp, url);
        String signature = null;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(signOriginal.getBytes("UTF-8"));
            signature = this.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Validate.notBlank(signature, (String)"\u83b7\u53d6jssdk\u65f6\u7b7e\u540d\u5931\u8d25", (Object[])new Object[0]);
        WXJsConfigVo vo = new WXJsConfigVo();
        vo.setAppId(wxProperties.getAppId());
        vo.setNonceStr(nonceStr);
        vo.setSignature(signature);
        vo.setTimestamp(timestamp);
        return vo;
    }

    private String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

