package com.biz.crm.cps.external.weixinsign.local.controller;

import com.biz.crm.cps.external.weixinsign.sdk.service.WXOpenPlatformVoService;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

/**
 * 微信开放平台
 *
 * @author 作者 hc
 */
@Api(value = "微信开放平台授权 controller")
@Controller
@RequestMapping("/v1/wx/openSso")
@Slf4j
public class WXChatOpenPlatformSsoController extends WxBaseController {

  @Autowired
  private WXOpenPlatformVoService wxOpenPlatformService;

  /**
   * 授权注册页面扫码授权
   *
   * @param redirectUri 授权成功后重定向地址 例如：redirectUri=http://xxxx/xxx/v1/wx/openSso/queryAuth?redirectUri=https://www.baidu.com
   * @return
   */
  @RequestMapping(value = "componentAuthPage")
  public ModelAndView componentAuthPage(String redirectUri) {
    String url = wxOpenPlatformService.getComponentAuthUrl(redirectUri);
    ModelAndView model = new ModelAndView("redirect:" + url);
    return model;
  }

  /**
   * 根据auth_code查询授权信息
   *
   * @param authCode  授权成功时获得的授权码
   * @param expiresIn 存活时间
   * @return
   */
  @RequestMapping(value = "/queryAuth")
  public ModelAndView queryAuth(@RequestParam("auth_code") String authCode,
          @RequestParam("expires_in") String expiresIn, @ApiParam("重定向url") @RequestParam(required = false) String redirectUri) {
    log.info("auth_code={},expires_in={}", authCode, expiresIn);
    wxOpenPlatformService.getApiQueryAuth(authCode);
    ModelAndView model = new ModelAndView("redirect:" + redirectUri);
    return model;
  }


  /**
   * 获取微信网页授权code
   *
   * @param redirectUri
   * @param appid
   * @return
   */
  @ApiOperation(value = "获取微信网页授权code")
  @GetMapping("/{appid}/authorize")
  public ModelAndView authorize(@ApiParam("重定向url") @RequestParam String redirectUri, @RequestParam(defaultValue = "snsapi_base") String scope,
          @PathVariable(value = "appid") String appid, HttpServletRequest request) {
    if (!this.isWeChat(request)) {
      ModelAndView mv = new ModelAndView("redirect:" + redirectUri);
      return mv;
    }
    String authorizeUrl = wxOpenPlatformService.getAuthorizeUrl(redirectUri, scope, appid);
    ModelAndView mv = new ModelAndView("redirect:" + authorizeUrl);
    return mv;
  }

  @ApiOperation(value = "获取openId")
  @GetMapping("/{appid}/findOpenId")
  public ModelAndView findOpenId(@ApiParam("重定向url") @RequestParam String redirectUri, @RequestParam(required = false) String code,
          @PathVariable(value = "appid") String appid, HttpServletRequest request) {
    if (this.isWeChat(request)) {
      Validate.notBlank(code, "微信环境下code不能为空");
    }
    WxWebViewAccessTokenRespVo accessTokenRespVo = wxOpenPlatformService.findWebViewAccessToken(code, appid);
    String openId = null;
    if (accessTokenRespVo != null) {
      openId = accessTokenRespVo.getOpenid();
    }
    ModelAndView mv = new ModelAndView("redirect:" + redirectUri + "?openid=" + openId);
    return mv;
  }
}
