package com.biz.crm.cps.external.weixinsign.local.controller;

import javax.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;

/**
 * @author hecheng
 * @description: 微信基础控制器，主要是一些微信的公共方法
 * @date 2021/10/19 上午10:13
 */
@Slf4j
public abstract class WxBaseController {

  /**
   * 判断是否是微信访问
   *
   * @param request
   * @return
   */
  protected boolean isWeChat(HttpServletRequest request) {
    String userAgent = request.getHeader("user-agent").toLowerCase();
    boolean flag = userAgent == null || userAgent.indexOf("micromessenger") <= 0 ? false : true;
    if (!flag) {
      log.warn("非微信浏览器访问");
    }
    return flag;
  }
}
