package com.biz.crm.cps.external.weixinsign.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.external.weixinsign.sdk.service.WXCacheVoService;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxCacheVo;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

/**
 * @author hecheng
 * @description: 微信本地缓存
 * @date 2021/9/8 下午8:31
 */
@Service
@ConditionalOnMissingBean(name = "WXCacheVoServiceExpandImpl")
public class DefaultWXCacheVoServiceImpl implements WXCacheVoService {

  private Map<String, String> cache = new ConcurrentHashMap<String, String>();

  @Override
  public String get(String key) {
    String jsonStr = cache.get(key);
    if (StringUtils.isNotBlank(jsonStr)) {
      try {
        WxCacheVo wxCacheVo = JSONObject.parseObject(jsonStr, WxCacheVo.class);
        long nowTimestamp = new Date().getTime();
        long createTimestamp = wxCacheVo.getCreateTimestamp();
        long expiresIn = wxCacheVo.getExpiresIn();
        //提前10s过期
        if ((nowTimestamp - createTimestamp) / 1000 <= expiresIn - 10) {
          return wxCacheVo.getValue();
        }
      } catch (Exception e) {
        return null;
      }
    }
    return null;
  }

  @Override
  public void set(String key, String jsonValue) {
    cache.put(key, jsonValue);
  }

  @Override
  public void set(String key, String jsonValue, long expiresIn) {
    cache.put(key, jsonValue);
  }

  @Override
  public void remove(String key) {
    cache.remove(key);
  }
}
