/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.weixinsign.local.controller;

import com.biz.crm.cps.external.weixinsign.local.controller.WxBaseController;
import com.biz.crm.cps.external.weixinsign.sdk.service.WXOpenPlatformVoService;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0\u6388\u6743 controller")
@Controller
@RequestMapping(value={"/v1/wx/openSso"})
public class WXChatOpenPlatformSsoController
extends WxBaseController {
    private static final Logger log = LoggerFactory.getLogger(WXChatOpenPlatformSsoController.class);
    @Autowired
    private WXOpenPlatformVoService wxOpenPlatformService;

    @RequestMapping(value={"componentAuthPage"})
    public ModelAndView componentAuthPage(String redirectUri) {
        String url = this.wxOpenPlatformService.getComponentAuthUrl(redirectUri);
        ModelAndView model = new ModelAndView("redirect:" + url);
        return model;
    }

    @RequestMapping(value={"/queryAuth"})
    public ModelAndView queryAuth(@RequestParam(value="auth_code") String authCode, @RequestParam(value="expires_in") String expiresIn, @ApiParam(value="\u91cd\u5b9a\u5411url") @RequestParam(required=false) String redirectUri) {
        log.info("auth_code={},expires_in={}", (Object)authCode, (Object)expiresIn);
        this.wxOpenPlatformService.getApiQueryAuth(authCode);
        ModelAndView model = new ModelAndView("redirect:" + redirectUri);
        return model;
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u7f51\u9875\u6388\u6743code")
    @GetMapping(value={"/{appid}/authorize"})
    public ModelAndView authorize(@ApiParam(value="\u91cd\u5b9a\u5411url") @RequestParam String redirectUri, @RequestParam(defaultValue="snsapi_base") String scope, @PathVariable(value="appid") String appid, HttpServletRequest request) {
        if (!this.isWeChat(request)) {
            ModelAndView mv = new ModelAndView("redirect:" + redirectUri);
            return mv;
        }
        String authorizeUrl = this.wxOpenPlatformService.getAuthorizeUrl(redirectUri, scope, appid);
        ModelAndView mv = new ModelAndView("redirect:" + authorizeUrl);
        return mv;
    }

    @ApiOperation(value="\u83b7\u53d6openId")
    @GetMapping(value={"/{appid}/findOpenId"})
    public ModelAndView findOpenId(@ApiParam(value="\u91cd\u5b9a\u5411url") @RequestParam String redirectUri, @RequestParam(required=false) String code, @PathVariable(value="appid") String appid, HttpServletRequest request) {
        if (this.isWeChat(request)) {
            Validate.notBlank((CharSequence)code, (String)"\u5fae\u4fe1\u73af\u5883\u4e0bcode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        WxWebViewAccessTokenRespVo accessTokenRespVo = this.wxOpenPlatformService.findWebViewAccessToken(code, appid);
        String openId = null;
        if (accessTokenRespVo != null) {
            openId = accessTokenRespVo.getOpenid();
        }
        ModelAndView mv = new ModelAndView("redirect:" + redirectUri + "?openid=" + openId);
        return mv;
    }
}

