/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.weixinsign.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.weixinsign.sdk.service.WXOpenVoService;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WXJsConfigReqVo;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WXJsConfigVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/wx/wxOpen"})
@Api(tags={"\u5fae\u4fe1http\u63a5\u53e3"})
public class WXOpenController {
    private static final Logger log = LoggerFactory.getLogger(WXOpenController.class);
    @Autowired
    private WXOpenVoService wxOpenService;

    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40jssdk\u914d\u7f6e")
    @GetMapping(value={"/findWXJsConfig"})
    public Result<WXJsConfigVo> findWXJsConfig(@ApiParam(value="\u7b7e\u540durl") String url, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) String appType) {
        try {
            WXJsConfigVo value = this.wxOpenService.findWXJsConfig(url, appType);
            return Result.ok((Object)value);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40jssdk\u914d\u7f6e")
    @PostMapping(value={"/findWXJsConfigPost"})
    public Result<WXJsConfigVo> findWXJsConfigPost(@RequestBody WXJsConfigReqVo reqVo) {
        try {
            if (StringUtils.isBlank((CharSequence)reqVo.getUrl())) {
                return Result.error((String)"\u7b7e\u540durl\u4e0d\u80fd\u4e3a\u7a7a");
            }
            WXJsConfigVo value = this.wxOpenService.findWXJsConfig(reqVo.getUrl(), reqVo.getAppType());
            return Result.ok((Object)value);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40token\u914d\u7f6e")
    @GetMapping(value={"/findAccessTokenByAppType"})
    public Result<String> findAccessTokenByAppType(@RequestParam(required=false) @ApiParam(value="\u5e94\u7528\u7c7b\u578b") String appType) {
        try {
            String value = this.wxOpenService.findAccessToken(appType);
            Result result = Result.ok((String)"");
            result.setResult((Object)value);
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6JsApiTicket\u914d\u7f6e")
    @GetMapping(value={"/findJsApiTicketByAppType"})
    public Result<String> findJsApiTicketByAppType(@RequestParam(required=false) @ApiParam(value="\u5e94\u7528\u7c7b\u578b") String appType) {
        try {
            String value = this.wxOpenService.findJsApiTicket(appType);
            Result result = Result.ok((String)"");
            result.setResult((Object)value);
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

