/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.weixinsign.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.weixinsign.sdk.service.WXOpenVoService;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/v1/wx/wxSso"})
@Api(tags={"\u5fae\u4fe1\u7f51\u9875\u6388\u6743\u63a5\u53e3"})
public class WXOpenSsoController {
    private static final Logger log = LoggerFactory.getLogger(WXOpenSsoController.class);
    @Autowired(required=false)
    private WXOpenVoService wxOpenService;

    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u7f51\u9875\u6388\u6743code")
    @GetMapping(value={"/authorize"})
    public ModelAndView authorize(@ApiParam(value="\u91cd\u5b9a\u5411url") @RequestParam String redirectUri, @RequestParam(defaultValue="snsapi_base") String scope, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) String appType, HttpServletRequest request) {
        if (this.isWeChat(request)) {
            ModelAndView mv = new ModelAndView("redirect:" + redirectUri);
            return mv;
        }
        String authorizeUrl = this.wxOpenService.getAuthorizeUrl(redirectUri, scope, appType);
        ModelAndView mv = new ModelAndView("redirect:" + authorizeUrl);
        return mv;
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u7f51\u9875\u6388\u6743accessToken")
    @GetMapping(value={"/findWebViewAccessToken"})
    @ResponseBody
    public Result<WxWebViewAccessTokenRespVo> findWebViewAccessToken(@ApiParam(value="code") @RequestParam String code, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) String appType) {
        try {
            WxWebViewAccessTokenRespVo accessTokenRespVo = this.wxOpenService.findWebViewAccessToken(code, appType);
            return Result.ok((Object)accessTokenRespVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    private boolean isWeChat(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        return userAgent != null && userAgent.indexOf("micromessenger") != -1;
    }
}

