/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.weixinsign.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.external.weixinsign.local.controller.WxBaseController;
import com.biz.crm.cps.external.weixinsign.sdk.event.WxUserInfoEventListener;
import com.biz.crm.cps.external.weixinsign.sdk.service.WXOpenVoService;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxUserInfoVo;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/v1/wx/wxSso"})
@Api(tags={"\u5fae\u4fe1\u7f51\u9875\u6388\u6743\u63a5\u53e3"})
public class WXOpenSsoController
extends WxBaseController {
    private static final Logger log = LoggerFactory.getLogger(WXOpenSsoController.class);
    @Autowired(required=false)
    private WXOpenVoService wxOpenService;
    @Autowired(required=false)
    private List<WxUserInfoEventListener> wxUserInfoEvents;

    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u7f51\u9875\u6388\u6743code")
    @GetMapping(value={"/authorize"})
    public ModelAndView authorize(@ApiParam(value="\u91cd\u5b9a\u5411url") @RequestParam String redirectUri, @RequestParam(defaultValue="snsapi_base") String scope, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) String appType, HttpServletRequest request) {
        if (!this.isWeChat(request)) {
            ModelAndView mv = new ModelAndView("redirect:" + redirectUri);
            return mv;
        }
        String authorizeUrl = this.wxOpenService.getAuthorizeUrl(redirectUri, scope, appType);
        ModelAndView mv = new ModelAndView("redirect:" + authorizeUrl);
        return mv;
    }

    @ApiOperation(value="\u83b7\u53d6openId")
    @GetMapping(value={"/findOpenId"})
    public ModelAndView findOpenId(@ApiParam(value="\u91cd\u5b9a\u5411url") @RequestParam String redirectUri, @RequestParam(required=false) String code, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) String appType, HttpServletRequest request) {
        if (this.isWeChat(request)) {
            Validate.notBlank((CharSequence)code, (String)"\u5fae\u4fe1\u73af\u5883\u4e0bcode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        WxWebViewAccessTokenRespVo accessTokenRespVo = this.wxOpenService.findWebViewAccessToken(code, appType);
        String openId = null;
        if (accessTokenRespVo != null) {
            openId = accessTokenRespVo.getOpenid();
        }
        ModelAndView mv = new ModelAndView("redirect:" + redirectUri + "?openid=" + openId);
        return mv;
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/findWxUserInfo"}, produces={"application/json;charset=utf-8"})
    public ModelAndView findWxUserInfo(@ApiParam(value="\u91cd\u5b9a\u5411url") @RequestParam String redirectUri, @RequestParam(required=false) String code, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) String appType, HttpServletRequest request) {
        WxUserInfoVo wxUserInfo;
        if (this.isWeChat(request)) {
            Validate.notBlank((CharSequence)code, (String)"\u5fae\u4fe1\u73af\u5883\u4e0bcode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        WxWebViewAccessTokenRespVo accessTokenRespVo = this.wxOpenService.findWebViewAccessToken(code, appType);
        String wxUserInfoStr = null;
        if (accessTokenRespVo != null && (wxUserInfo = this.wxOpenService.findWxUserInfo(accessTokenRespVo.getOpenid(), accessTokenRespVo.getAccessToken(), null)) != null) {
            wxUserInfoStr = JSONObject.toJSONString((Object)wxUserInfo);
        }
        ModelAndView mv = new ModelAndView("redirect:" + redirectUri + "?wxUserInfo=" + wxUserInfoStr);
        return mv;
    }
}

