/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.weixinsign.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.external.weixinsign.sdk.service.WXCacheVoService;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxCacheVo;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"WXCacheVoServiceExpandImpl"})
public class DefaultWXCacheVoServiceImpl
implements WXCacheVoService {
    private Map<String, String> cache = new ConcurrentHashMap<String, String>();

    public String get(String key) {
        String jsonStr = this.cache.get(key);
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            try {
                WxCacheVo wxCacheVo = (WxCacheVo)JSONObject.parseObject((String)jsonStr, WxCacheVo.class);
                long nowTimestamp = new Date().getTime();
                long createTimestamp = wxCacheVo.getCreateTimestamp();
                long expiresIn = wxCacheVo.getExpiresIn();
                if ((nowTimestamp - createTimestamp) / 1000L <= expiresIn - 10L) {
                    return wxCacheVo.getValue();
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void set(String key, String jsonValue) {
        this.cache.put(key, jsonValue);
    }

    public void set(String key, String jsonValue, long expiresIn) {
        this.cache.put(key, jsonValue);
    }

    public void remove(String key) {
        this.cache.remove(key);
    }
}

