/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.weixinsign.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.external.weixinsign.sdk.service.WXCacheVoService;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxCacheVo;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisWXCacheVoServiceImpl
implements WXCacheVoService {
    private RedisTemplate redisTemplate;

    public RedisWXCacheVoServiceImpl(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String get(String key) {
        String jsonStr = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            try {
                WxCacheVo wxCacheVo = (WxCacheVo)JSONObject.parseObject((String)jsonStr, WxCacheVo.class);
                return wxCacheVo.getValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void set(String key, String jsonValue) {
        WxCacheVo wxCacheVo = (WxCacheVo)JSONObject.parseObject((String)jsonValue, WxCacheVo.class);
        this.redisTemplate.opsForValue().set((Object)key, (Object)jsonValue, wxCacheVo.getExpiresIn(), TimeUnit.SECONDS);
    }

    public void set(String key, String jsonValue, long expiresIn) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)jsonValue, expiresIn, TimeUnit.SECONDS);
    }

    public void remove(String key) {
        this.redisTemplate.expire((Object)key, 0L, TimeUnit.SECONDS);
    }
}

