package com.biz.crm.cps.external.weixinsign.sdk.common.constant;

/**
 * @ClassName: WXOpenConstant
 * @Author: hecheng
 * @Description: 微信公众号常量配置
 * @Version: 1.0
 */
public class WXOpenConstant {

  private WXOpenConstant() {

  }

  /**
   * 微信公众号缓存
   */
  public static final String OPEN_CACHE_ACCESS_TOKEN_FORMAT = "OPEN_CACHE_ACCESS_TOKEN:%s";


  /**
   * 微信jssdk缓存
   */
  public static final String OPEN_CACHE_JSAPI_TICKET_FORMAT = "OPEN_CACHE_JSAPI_TICKET:%s";
  /**
   * 微信第三方平台 componentVerifyTicket缓存
   */
  public static final String OPEN_CACHE_COMPONENT_VERIFY_TICKET_FORMAT = "OPEN_CACHE_COMPONENT_VERIFY_TICKET:%s";
  /**
   * 微信第三方平台 componentAccessToken缓存
   */
  public static final String OPEN_CACHE_COMPONENT_ACCESS_TOKEN_FORMAT = "OPEN_CACHE_COMPONENT_ACCESS_TOKEN_TICKET:%s";
  /**
   * 微信第三方平台 apiqueryauth 第三方平台authorizerAccessToken 缓存
   */
  public static final String OPEN_CACHE_COMPONENT_AUTHORIZER_ACCESS_TOKEN_FORMAT = "OPEN_CACHE_COMPONENT_AUTHORIZER_ACCESS_TOKEN:%s";
  /**
   * 微信第三方平台 apiqueryauth 第三方平台authorizer refresh Token 缓存
   */
  public static final String OPEN_CACHE_COMPONENT_AUTHORIZER_REFRESH_TOKEN_FORMAT = "OPEN_CACHE_COMPONENT_AUTHORIZER_REFRESH_TOKEN:%s";
  /**
   * 微信公众号缓存 锁key
   */
  public static final String OPEN_CACHE_ACCESS_TOKEN_KEY_FORMAT = "OPEN_CACHE_ACCESS_TOKEN_KEY:%s";
  /**
   * 微信jssdk缓存 锁key
   */
  public static final String OPEN_CACHE_JSAPI_TICKET_KEY_FORMAT = "OPEN_CACHE_JSAPI_TICKET_KEY:%s";
  /**
   * 微信第三方平台 componentVerifyTicket缓存 锁key
   */
  public static final String OPEN_CACHE_COMPONENT_VERIFY_TICKET_KEY_FORMAT = "OPEN_CACHE_COMPONENT_VERIFY_TICKET_KEY:%s";
  /**
   * 微信第三方平台 componentAccessToken缓存 锁key
   */
  public static final String OPEN_CACHE_COMPONENT_ACCESS_TOKEN_KEY_FORMAT = "OPEN_CACHE_COMPONENT_ACCESS_TOKEN_TICKET_KEY:%s";
  /**
   * 微信第三方平台 apiqueryauth 第三方平台authorizerAccessToken 缓存 锁key
   */
  public static final String OPEN_CACHE_COMPONENT_AUTHORIZER_ACCESS_TOKEN_KEY_FORMAT = "OPEN_CACHE_COMPONENT_AUTHORIZER_ACCESS_TOKEN_KEY:%s";
  /**
   * 微信第三方平台 apiqueryauth 第三方平台authorizer refresh Token 缓存 锁key
   */
  public static final String OPEN_CACHE_COMPONENT_AUTHORIZER_REFRESH_TOKEN_KEY_FORMAT = "OPEN_CACHE_COMPONENT_AUTHORIZER_REFRESH_TOKEN_KEY:%s";
  /**
   * 微信 token 有效期
   */
  public static final int TOKEN_EXPIRESIN = 7200;
  /**
   * 微信公众号全局token
   */
  public static final String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token";
  /**
   * 微信公众号获取  jsapi ticket
   */
  public static final String JSAPI_TICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket";
  /**
   * 微信公众号获取 网页授权token
   */
  public static final String WEB_VIEW_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token";

  /**
   * 第三方平台代公众号发起微信公众号获取 网页授权token
   */
  public static final String COMPONENT_WEB_VIEW_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/component/access_token";
  /**
   * 在公众号/小程序接口调用令牌（authorizer_access_token）失效时，可以使用刷新令牌
   */
  public static final String COMPONENT_API_AUTHORIZER_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/component/api_authorizer_token";
  /**
   * 微信令牌（component_access_token）是第三方平台接口的调用凭据
   */
  public static final String API_COMPONENT_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/component/api_component_token";

  /**
   * 当用户在第三方平台授权页中完成授权流程后，第三方平台开发者可以在回调 URI 中通过 URL 参数获取授权码。使用以下接口可以换取公众号/小程序的授权信息。建议保存授权信息中的刷新令牌（authorizer_refresh_token）
   */
  public static final String API_QUERY_AUTH_URL = "https://api.weixin.qq.com/cgi-bin/component/api_query_auth";
  /**
   * 发送客服消息
   */
  public static final String CUSTOM_MESSAGE_URL = "https://api.weixin.qq.com/cgi-bin/message/custom/send";
  /**
   * 预授权码（pre_auth_code）是第三方平台方实现授权托管的必备信息，每个预授权码有效期为 1800秒。需要先获取令牌才能调用
   */
  public static final String API_CREATE_PREAUTHCODE_URL = "https://api.weixin.qq.com/cgi-bin/component/api_create_preauthcode";
  /**
   * 获取微信网页授权code
   */
  public static final String AUTHORIZE_URL_FORMAT = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=123#wechat_redirect";
  /**
   * 第三方平台代公众号发起网页授权 获取微信网页授权code
   */
  public static final String COMPONENT_AUTHORIZE_URL_FORMAT = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=123&component_appid=%s#wechat_redirect";
  /**
   * 微信公众号成功标志
   */
  public static final String SUCCESS = "0";
  /**
   * 微信公众号jssdk sign签名格式
   */
  public static final String SIGN_FORMAT = "jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s";

  /**
   * 微信公众号jssdk sign签名格式
   */
  public static final String FIND_USER_INFO = "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=%s";
}
