package com.biz.crm.cps.external.weixinsign.sdk.common.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @author hecheng
 * @Description: 微信消息类型
 **/
public enum WXMsgTypeEnum {
  /**
   * 文本
   */
  TEXT("text", "文本"),
  /**
   * 图片
   */
  IMAGE("image", "图片"),
  /**
   * 语音
   */
  VOICE("voice", "语音"),
  /**
   * 视频
   */
  VIDEO("video", "视频"),
  /**
   * 音乐
   */
  MUSIC("music", "音乐"),
  /**
   * 图文
   */
  NEWS("news", "图文"),
  /**
   * 事件
   */
  EVENT("event", "事件");

  private String code;
  private String des;

  WXMsgTypeEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * code转数组
   *
   * @return
   */
  public static Set<String> codeToSet() {
    Set<String> codes = new HashSet<>();
    for (WXMsgTypeEnum enableStatusEnum : WXMsgTypeEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code获取文字描述
   *
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      WXMsgTypeEnum[] values = WXMsgTypeEnum.values();
      for (WXMsgTypeEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }


  /**
   * 判断枚举中是否包含该code
   *
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    WXMsgTypeEnum[] values = WXMsgTypeEnum.values();
    for (WXMsgTypeEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }

}

