package com.biz.crm.cps.external.weixinsign.sdk.common.utils.msg;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 文本消息回复
 *
 * @author hc
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class TextMsgReplyXML {

  /**
   * 即接收者）为公众号/小程序原始 ID
   */
  @XmlElement(name = "ToUserName")
  private String toUserName;
  /**
   * 开发者微信号
   */
  @XmlElement(name = "FromUserName")
  private String fromUserName;
  /**
   * 消息创建时间 （整型）
   */
  @XmlElement(name = "CreateTime")
  private Long createTime;
  /**
   * 消息类型 {@see com.biz.crm.cps.external.weixinsign.sdk.common.enums.WXMsgTypeEnum}
   */
  @XmlElement(name = "MsgType")
  private String msgType;
  /**
   * 文本消息内容
   */
  @XmlElement(name = "Content")
  private String content;


}
