package com.biz.crm.cps.external.weixinsign.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.external.weixinsign.sdk.common.utils.msg.EventReceiveXML;
import com.biz.crm.cps.external.weixinsign.sdk.dto.ComponentVerifyTicketDto;
import com.biz.crm.cps.external.weixinsign.sdk.dto.MsgEventDto;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WXJsConfigVo;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;

/**
 * 微信开放平台 接口
 *
 * @author hecheng
 */
public interface WXOpenPlatformVoService {

  /**
   * 验证票据
   *
   * @param componentVerifyTicketDto
   * @return
   */
  void componentVerifyTicket(ComponentVerifyTicketDto componentVerifyTicketDto);

  /**
   * 处理微信消息事件
   *
   * @param msgEventDto
   */
  EventReceiveXML analyzeMsgEvent(MsgEventDto msgEventDto);

  /**
   * 获取component_access_token
   * <pre>
   * 第三方平台component_access_token是第三方平台的下文中接口的调用凭据，也叫做令牌（component_access_token）。
   * 每个令牌是存在有效期（2小时）的，且令牌的调用不是无限制的，请第三方平台做好令牌的管理，在令牌快过期时（比如1小时50分）再进行刷新（2000次）
   * </pre>
   *
   * @return
   */
  String getComponentAccessToken();

  /**
   * 使用授权码获取授权信息
   * <pre>
   * 当用户在第三方平台授权页中完成授权流程后，
   * 第三方平台开发者可以在回调 URI 中通过 URL 参数获取授权码。
   * 使用以下接口可以换取公众号/小程序的授权信息。建议保存授权信息中的刷新令牌（authorizer_refresh_token）
   * </pre>
   *
   * @param authorizationCode
   * @return
   */
  String getApiQueryAuth(String authorizationCode);

  /**
   * 发送客户消息
   *
   * @param message
   * @param authorizerAccessToken
   * @return
   */
  String customSendMessage(JSONObject message, String authorizerAccessToken);

  /**
   * 获取pre_auth_code,该API用于获取预授权码。预授权码用于公众号或小程序授权时的第三方平台方安全验证(不可重复使用)
   *
   * @return
   */
  String getPreAuthCode();

  /**
   * 创建公众号授权页面url
   *
   * @param redirectUri
   * @return
   */
  String getComponentAuthUrl(String redirectUri);

  /**
   * 获取微信网页授权code
   *
   * @param redirectUri
   * @param scope
   * @param appid
   * @return
   */
  String getAuthorizeUrl(String redirectUri, String scope, String appid);

  /**
   * 获取微信网页授权
   *
   * @param code
   * @param appid
   * @return
   */
  WxWebViewAccessTokenRespVo findWebViewAccessToken(String code, String appid);

  /**
   * 获取微信公众号对应的 jssdk
   *
   * @param url
   * @param appid
   * @return
   */
  WXJsConfigVo findWXJsConfig(String url, String appid);

  /**
   * 获取JsApiTicket
   *
   * @param appid
   * @return
   */
  String findJsApiTicket(String appid);

  /**
   * 在公众号/小程序接口调用令牌（authorizer_access_token）失效时，可以使用刷新令牌（authorizer_refresh_token）获取新的接口调用令牌。使用过程中如遇到问题，可在开放平台服务商专区发帖交流。
   *
   * @param appid
   * @return
   */
  String findApiAuthorizerToken(String appid);
}
