package com.biz.crm.cps.external.weixinsign.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: 微信公众号 jssdk 调用配置
 * @date 2021/9/8 下午2:51
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "WXJsConfigVo", description = "微信公众号 jssdk 调用配置")
public class WXJsConfigVo {

  /**
   * 微信公众号appId
   */
  @ApiModelProperty("微信公众号appId")
  private String appId;
  /**
   * 生成签名的随机串
   */
  @ApiModelProperty("生成签名的随机串")
  private String nonceStr;
  /**
   * 生成签名的时间戳
   */
  @ApiModelProperty("生成签名的时间戳")
  private long timestamp;
  /**
   * 签名
   */
  @ApiModelProperty("签名")
  private String signature;
}
