package com.biz.crm.cps.external.weixinsign.sdk.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: 微信公众号 JsApiTicket vo
 * @date 2021/9/8 下午3:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "WxJsApiTicketRespVo", description = "微信公众号 JsApiTicket vo")
public class WxJsApiTicketRespVo extends WXErrVo {

  /**
   * 接口中签名所需凭证
   */
  @ApiModelProperty("接口中签名所需凭证")
  @JsonProperty("ticket")
  private String ticket;
  /**
   * 凭证有效时间，单位：秒s
   */
  @ApiModelProperty("凭证有效时间，单位：秒")
  @JsonProperty("expires_in")
  private long expiresIn;
}
