package com.biz.crm.cps.external.weixinsign.sdk.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description:  微信用户信息 vo
 * @date 2021/9/8 下午3:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "WxUserInfoVo", description = "微信用户信息 vo")
public class WxUserInfoVo extends WXErrVo {

  /**
   * 用户个人资料填写的省份
   */
  @JsonProperty("province")
  private String province;
  /**
   * 普通用户个人资料填写的城市
   */
  @JsonProperty("city")
  private long city;
  /**
   * 国家，如中国为CN
   */
  @JsonProperty("country")
  private String country;

  /**
   * 用户唯一标识，请注意，在未关注公众号时，用户访问公众号的网页，也会产生一个用户和公众号唯一的OpenID
   */
  @JsonProperty("openid")
  private String openid;
  /**
   * 用户昵称
   */
  @JsonProperty("nickname")
  private String nickName;

  /**
   * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空。若用户更换头像，原有头像URL将失效
   */
  @JsonProperty("headimgurl")
  private String headImgUrl;
}
