package com.biz.crm.cps.external.weixinsign.sdk.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: 微信网页授权 token vo
 * @date 2021/9/8 下午3:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "WxWebViewAccessTokenRespVo", description = "微信网页授权 token vo")
public class WxWebViewAccessTokenRespVo extends WXErrVo {

  /**
   * 获取到的凭证
   */
  @ApiModelProperty("获取到的凭证")
  @JsonProperty("access_token")
  private String accessToken;
  /**
   * 凭证有效时间，单位：秒s
   */
  @ApiModelProperty("凭证有效时间，单位：秒")
  @JsonProperty("expires_in")
  private long expiresIn;
  /**
   * 用户刷新access_token
   */
  @JsonProperty("refresh_token")
  private String refreshToken;

  /**
   * 用户唯一标识，请注意，在未关注公众号时，用户访问公众号的网页，也会产生一个用户和公众号唯一的OpenID
   */
  @JsonProperty("openid")
  private String openid;
  /**
   * 用户授权的作用域，使用逗号（,）分隔
   */
  @JsonProperty("scope")
  private String scope;
}
