/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.cash.zhangfangyun.local.service.observer;

import com.biz.crm.cps.business.cash.sdk.common.enums.CashStatusEnum;
import com.biz.crm.cps.business.cash.sdk.dto.CashConditionDto;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordDto;
import com.biz.crm.cps.business.cash.sdk.service.CashRecordVoService;
import com.biz.crm.cps.business.cash.sdk.service.observer.CashMountRegister;
import com.biz.crm.cps.business.cash.sdk.service.observer.CashServiceObserver;
import com.biz.crm.cps.business.cash.sdk.vo.CashProcessVo;
import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;
import com.biz.crm.cps.external.cash.zhangfangyun.local.entity.FadadaAccount;
import com.biz.crm.cps.external.cash.zhangfangyun.local.service.FadadaAccountService;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.common.enums.FadadaAccountTypeEnum;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.common.enums.FadadaCompanyVerifyStatusEnum;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.common.enums.FadadaPersonVerifyStatusEnum;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ZhangFangYunCashMountRegisterImpl")
public class ZhangFangYunCashServiceObserverImpl
implements CashServiceObserver {
    @Autowired
    @Qualifier(value="ZhangFangYunCashMountRegisterImpl")
    private CashMountRegister cashMountRegister;
    @Autowired
    private FadadaAccountService fadadaAccountService;
    @Autowired(required=false)
    private CashRecordVoService cashRecordVoService;

    public CashProcessVo onRequestCashProcess(CashConditionDto cashCondition) {
        if (Objects.isNull(cashCondition) || !Objects.equals(cashCondition.getCashKey(), this.cashMountRegister.getKey())) {
            return null;
        }
        CashProcessVo vo = new CashProcessVo();
        boolean needVerify = this.requiredAgainVerify(cashCondition);
        vo.setNeedVerify(needVerify);
        if (needVerify) {
            String url = this.createVerifyUrl(cashCondition);
            vo.setVerifyUrl(url);
        }
        return vo;
    }

    @Transactional
    public CashProcessVo onCreateContract(CashConditionDto cashCondition) {
        return null;
    }

    @Transactional
    public CashRecordVo onCash(CashConditionDto cashCondition) {
        Validate.notNull((Object)cashCondition, (String)"\u5151\u4ed8\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)cashCondition.getAmount(), (String)"\u5151\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((cashCondition.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5151\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        if (Objects.equals(cashCondition.getCashKey(), this.cashMountRegister.getKey())) {
            CashRecordDto cashRecordDto = new CashRecordDto();
            cashRecordDto.setAmount(cashCondition.getAmount());
            cashRecordDto.setParticipatorCode(cashCondition.getParticipatorCode());
            cashRecordDto.setParticipatorType(cashCondition.getParticipatorFlag());
            cashRecordDto.setParticipatorName(cashCondition.getParticipatorName());
            cashRecordDto.setCashMethodKey(this.cashMountRegister.getKey());
            cashRecordDto.setCashMethodName(this.cashMountRegister.getName());
            cashRecordDto.setCashStatus(CashStatusEnum.NO_PAID.getDictCode());
            cashRecordDto.setRewardKey(cashCondition.getRewardKey());
            cashRecordDto.setRewardName(cashCondition.getRewardName());
            cashRecordDto.setPayeeName(cashCondition.getPayeeName());
            cashRecordDto.setPayeePhone(cashCondition.getPayeePhone());
            cashRecordDto.setPayeeCode(cashCondition.getPayeeCode());
            CashRecordVo cashRecordVo = this.cashRecordVoService.create(cashRecordDto);
            return cashRecordVo;
        }
        return null;
    }

    private boolean requiredAgainVerify(CashConditionDto cashCondition) {
        String usetType;
        String loginAccount = cashCondition.getPayeeCode();
        FadadaAccount account = this.fadadaAccountService.findByUserAccountAndUserType(loginAccount, usetType = cashCondition.getParticipatorFlag());
        if (account == null) {
            return true;
        }
        return (!Objects.equals(account.getAccountType(), FadadaAccountTypeEnum.PERSON.getDictCode()) || !Objects.equals(account.getVerifyStatus(), FadadaPersonVerifyStatusEnum.PASSED)) && (!Objects.equals(account.getAccountType(), FadadaAccountTypeEnum.COMPANY.getDictCode()) || !Objects.equals(account.getVerifyStatus(), FadadaCompanyVerifyStatusEnum.PASSED));
    }

    private String createVerifyUrl(CashConditionDto cashCondition) {
        String loginAccount = cashCondition.getPayeeCode();
        String usetType = cashCondition.getParticipatorFlag();
        FadadaAccount account = new FadadaAccount();
        account.setUserName(loginAccount);
        account.setUserType(usetType);
        account = this.fadadaAccountService.save(account);
        return account.getVerifyUrl();
    }
}

