/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.cash.zhangfangyun.local.controller;

import com.biz.crm.cps.external.cash.zhangfangyun.local.service.ContractSignService;
import com.biz.crm.cps.external.cash.zhangfangyun.local.service.FadadaAccountService;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.dto.ContractSignNotifyDto;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.dto.FadadaAuthDto;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.model.FadadaResult;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.service.FadadaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6cd5\u5927\u5927"})
@RequestMapping(value={"/v1/zhangfangyun/fadada"})
@RestController
public class FadadaController {
    private static final Logger log = LoggerFactory.getLogger(FadadaController.class);
    @Autowired
    private FadadaService fadadaService;
    @Autowired
    private FadadaAccountService fadadaAccountService;
    @Autowired
    private ContractSignService contractSignService;

    @GetMapping(value={"registerAccount"})
    @ApiOperation(value="\u6ce8\u518c\u8d26\u53f7")
    public FadadaResult registerAccount(String userAccount, String accountType) {
        try {
            return this.fadadaService.registerAccount(userAccount, accountType);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return FadadaResult.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findPersonVerifyUrl"})
    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740")
    public FadadaResult findPersonVerifyUrl(String customerId, String verifiedWay, String pageModify) {
        try {
            return this.fadadaService.findPersonVerifyUrl(customerId, verifiedWay, pageModify);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return FadadaResult.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"applyCert"})
    @ApiOperation(value="\u5b9e\u540d\u8bc1\u4e66\u7533\u8bf7")
    public FadadaResult applyCert(String customerId, String transactionNo) {
        try {
            return this.fadadaService.applyCert(customerId, transactionNo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return FadadaResult.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findAuthSignUrl"})
    @ApiOperation(value="\u83b7\u53d6\u6388\u6743\u81ea\u52a8\u7b7e\u7f72\u5730\u5740")
    public String findAuthSignUrl(String contractId, String customerId, String transactionId) {
        try {
            return this.fadadaService.findAuthSignUrl(contractId, customerId, transactionId);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }

    @PostMapping(value={"updateAccountStatus"})
    @ApiOperation(value="\u4fee\u6539\u6cd5\u5927\u5927\u8ba4\u8bc1\u4fe1\u606f\uff0c\u5b9e\u540d\u8ba4\u8bc1\u5f02\u6b65\u56de\u8c03\u5730\u5740")
    public FadadaResult updateAccountStatus(@ApiParam(name="dto", value="\u6cd5\u5927\u5927\u8ba4\u8bc1\u4fe1\u606f") FadadaAuthDto dto) {
        try {
            this.fadadaAccountService.updateStatus(dto);
            return FadadaResult.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return FadadaResult.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"updateSignStatus"})
    @ApiOperation(value="\u4fee\u6539\u5408\u540c\u7b7e\u7f72\u72b6\u6001\uff0c\u5408\u540c\u7b7e\u7f72\u65f6\u5f02\u6b65\u56de\u8c03\u63a5\u53e3")
    public FadadaResult updateSignStatus(@ApiParam(name="contractSignNotifyDto", value="\u5408\u540c\u5bf9\u8c61") ContractSignNotifyDto contractSignNotifyDto) {
        try {
            this.contractSignService.updateStatus(contractSignNotifyDto);
            return FadadaResult.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return FadadaResult.error((String)e.getMessage());
        }
    }
}

