/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.cash.zhangfangyun.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.cash.zhangfangyun.local.entity.ContractSign;
import com.biz.crm.cps.external.cash.zhangfangyun.local.entity.ContractTemplate;
import com.biz.crm.cps.external.cash.zhangfangyun.local.entity.FadadaAccount;
import com.biz.crm.cps.external.cash.zhangfangyun.local.repository.ContractSignRepository;
import com.biz.crm.cps.external.cash.zhangfangyun.local.service.ContractSignService;
import com.biz.crm.cps.external.cash.zhangfangyun.local.service.ContractTemplateService;
import com.biz.crm.cps.external.cash.zhangfangyun.local.service.FadadaAccountService;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.common.enums.FadadaAccountTypeEnum;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.dto.ContractSignNotifyDto;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.dto.ContractTemplatePdfParamsDto;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.model.FadadaResult;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.service.FadadaService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.fadada.sdk.base.model.req.ExtSignAutoParams;
import com.fadada.sdk.base.model.req.ExtSignParams;
import com.fadada.sdk.base.model.req.GenerateContractParams;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractSignServiceImpl
implements ContractSignService {
    @Autowired
    private ContractSignRepository contractSignRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private FadadaService fadadaService;
    @Autowired
    private FadadaAccountService fadadaAccountService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ContractTemplateService contractTemplateService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public ContractSign findByCustomerIdAndTemplateId(String customerId, String templateId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{customerId, templateId})) {
            return null;
        }
        return this.contractSignRepository.findByCustomerIdAndTemplateId(customerId, templateId);
    }

    @Override
    @Transactional
    public ContractSign create(ContractSign contractSign) {
        this.createValidation(contractSign);
        contractSign.setSignTime(new Date());
        this.generateContract(contractSign);
        ContractSign companyContractSign = this.buildCompanyContractSign(contractSign);
        ContractSign personContractSign = this.buildPersonContractSign(contractSign);
        ArrayList<ContractSign> list = new ArrayList<ContractSign>();
        list.add(companyContractSign);
        list.add(personContractSign);
        this.contractSignRepository.saveBatch(list);
        return personContractSign;
    }

    @Override
    @Transactional
    public ContractSign updateStatus(ContractSignNotifyDto contractSignNotifyDto) {
        Validate.notNull((Object)contractSignNotifyDto, (String)"\u4fee\u6539\u5408\u540c\u7b7e\u7f72\u72b6\u6001\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractSignNotifyDto.getTransaction_id(), (String)"\u4fee\u6539\u5408\u540c\u7b7e\u7f72\u72b6\u6001\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ContractSign contractSign = this.contractSignRepository.findByTransactionId(contractSignNotifyDto.getTransaction_id());
        Validate.notNull((Object)((Object)contractSign), (String)"\u672a\u67e5\u8be2\u5230\u8981\u4fee\u6539\u7684\u5408\u540c\u7b7e\u7f72\u4fe1\u606f\uff01", (Object[])new Object[0]);
        contractSign.setSignStatus(contractSignNotifyDto.getResult_code());
        contractSign.setSignDesc(contractSignNotifyDto.getResult_desc());
        contractSign.setDownloadUrl(contractSignNotifyDto.getDownload_url());
        contractSign.setViewUrl(contractSignNotifyDto.getViewpdf_url());
        this.contractSignRepository.updateById((Object)contractSign);
        FadadaAccount byCustomerId = this.fadadaAccountService.findByCustomerId(contractSign.getCustomerId());
        if (byCustomerId != null && FadadaAccountTypeEnum.PERSON.getDictCode().equals(byCustomerId.getAccountType())) {
            this.fadadaService.archiveContractByContractId(contractSign.getContractId());
        }
        return contractSign;
    }

    @Override
    public ContractSign findByCurrentUser() {
        String userType;
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey((String)loginUser.getUsertype());
        String userAccount = loginUser.getAccount();
        FadadaAccount fadadaAccount = this.fadadaAccountService.findByUserAccountAndUserType(userAccount, userType = participatorTypeEnum.getDictCode());
        if (fadadaAccount == null) {
            return null;
        }
        ContractTemplate contractTemplate = this.contractTemplateService.findTopOne();
        if (contractTemplate == null) {
            return null;
        }
        ContractSign contractSign = this.contractSignRepository.findByCustomerIdAndTemplateId(fadadaAccount.getCustomerId(), contractTemplate.getTemplateId());
        String viewUrl = this.fadadaService.findContractByContractId(contractSign.getContractId());
        String downLoadUrl = this.fadadaService.downLoadContractByContractId(contractSign.getContractId());
        contractSign.setDownloadUrl(downLoadUrl);
        contractSign.setViewUrl(viewUrl);
        return contractSign;
    }

    private void createValidation(ContractSign contractSign) {
        Validate.notNull((Object)((Object)contractSign), (String)"\u7b7e\u7f72\u5408\u540c\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        contractSign.setId(null);
        Validate.notBlank((CharSequence)contractSign.getCustomerId(), (String)"\u7b7e\u7f72\u5408\u540c\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractSign.getTemplateId(), (String)"\u7b7e\u7f72\u5408\u540c\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void generateContract(ContractSign contractSign) {
        String contractId = null;
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        contractId = Objects.nonNull(this.generateCodeService) ? StringUtils.join((Object[])new String[]{"FWHT", date, (String)this.generateCodeService.generateCode("contractSign", 1).get(0)}) : StringUtils.join((Object[])new String[]{"FWHT", date, UUID.randomUUID().toString().replace("-", "")});
        GenerateContractParams params = new GenerateContractParams();
        params.setDocTitle(contractSign.getDocTitle());
        params.setContractId(contractId);
        params.setTemplateId(contractSign.getTemplateId());
        ContractTemplatePdfParamsDto paramsDto = contractSign.getParamsDto();
        if (paramsDto != null) {
            params.setParameterMap(JSONObject.toJSONString((Object)paramsDto));
        }
        FadadaResult fadadaResult = this.fadadaService.generateContract(params);
        contractSign.setDownloadUrl(fadadaResult.getDownload_url());
        contractSign.setViewUrl(fadadaResult.getViewpdf_url());
        contractSign.setContractId(contractId);
    }

    private ContractSign buildCompanyContractSign(ContractSign contractSign) {
        ContractSign companyContractSign = (ContractSign)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractSign, ContractSign.class, null, null, new String[0]));
        FadadaAccount byAccountType = this.fadadaAccountService.findByAccountType(FadadaAccountTypeEnum.COMPANY.getDictCode());
        Validate.notNull((Object)((Object)byAccountType), (String)"\u4f01\u4e1a\u81ea\u52a8\u7b7e\u7f72\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u4fe1\u606f\uff01", (Object[])new Object[0]);
        String replace = UUID.randomUUID().toString().replace("-", "");
        ExtSignAutoParams params = new ExtSignAutoParams();
        params.setTransactionId(replace);
        params.setDocTitle(companyContractSign.getDocTitle());
        params.setContractId(companyContractSign.getContractId());
        params.setCustomerId(byAccountType.getCustomerId());
        FadadaResult fadadaResult = this.fadadaService.extSignAuto(params);
        companyContractSign.setTransactionId(replace);
        companyContractSign.setCustomerId(byAccountType.getCustomerId());
        companyContractSign.setDownloadUrl(fadadaResult.getDownload_url());
        companyContractSign.setViewUrl(fadadaResult.getViewpdf_url());
        companyContractSign.setCreateAccount(byAccountType.getUserName());
        companyContractSign.setModifyAccount(byAccountType.getUserName());
        companyContractSign.setTenantCode(TenantUtils.getTenantCode());
        companyContractSign.setCreateTime(new Date());
        companyContractSign.setModifyTime(new Date());
        companyContractSign.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        companyContractSign.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return companyContractSign;
    }

    private ContractSign buildPersonContractSign(ContractSign contractSign) {
        String replace = UUID.randomUUID().toString().replace("-", "");
        ExtSignParams params = new ExtSignParams();
        params.setContractId(contractSign.getContractId());
        params.setCustomerId(contractSign.getCustomerId());
        params.setDocTitle(contractSign.getDocTitle());
        params.setTransactionId(replace);
        String signUrl = this.fadadaService.extSign(params);
        contractSign.setTransactionId(replace);
        contractSign.setSignUrl(signUrl);
        contractSign.setTenantCode(TenantUtils.getTenantCode());
        contractSign.setCreateTime(new Date());
        contractSign.setCreateAccount(this.loginUserService.getLoginAccountName());
        contractSign.setModifyTime(new Date());
        contractSign.setModifyAccount(this.loginUserService.getLoginAccountName());
        contractSign.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        contractSign.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return contractSign;
    }
}

